*******************************************
* Agreggate Data pour fichiers fiscaux    *
*******************************************


clear
set more off


**************************************************************************

foreach pas of global yearliste {
		
		global year=`pas'
		use "$wfrev/rev${year}.dta",clear
		keep if idnum==1 & pac==0
		order rfin_mv_irpp_foy,after(rfin_pv_irpp_foy)
		drop idfoy-idindiv ntot-mat rfin_pv_pro_irpp_foy- frais_prof_foy
		
		gen nff=1
		ds year pondn, not
		foreach var of varlist `r(varlist)' {
			egen `var'tot=sum(`var'*pondn)
			drop `var'
			rename `var'tot `var'
		}
		
		keep if _n==1
		keep year nff *_foy
		#delimit;
			order year nff salchom* sal* chom* pens* rente* nonsal_foy  nonsal_irpp_foy defnonsal_irpp_foy nonsalexo_irpp_foy 
			rfon_irpp_foy rfon_micro_irpp_foy  rfon_normal_irpp_foy  rfon_defcat_foy  rfon_defglo_foy 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy* rfin_int_bar_irpp_foy* rfin_int_pl_irpp_foy rfin_div_irpp_foy* rfin_div_bar_irpp_foy* rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_mv_irpp_foy  ;
		 #delimit cr
		* Agregats en milliards d'euros et nbre d efoyers fiscaux en milliers
			replace nff=nff/1000
			foreach var of varlist salchom_irpp_foy- rfin_mv_irpp_foy {
				replace `var'=`var'/1000000000
			}
		* Exportation 
			if (${casd}==0 & $year>1970)  {
				append  using "`temp'"
				erase "`temp'"
			}
					
			if (${casd}==1 & $year>1994) {
				append using "`temp'"
				erase "`temp'"
			}
		tempfile temp
		save "`temp'",replace
}	
	erase "`temp'"
	save "$resultsrev/raw results/agregatetaxinc.dta",replace 	
	import excel using "$resultsrev/raw results/agregatetaxinc.xlsx", first clear sheet("Feuil1")  cellrange()
	append using "$resultsrev/raw results/agregatetaxinc.dta"
	sort year 
	save "$resultsrev/raw results/agregatetaxinc.dta",replace


 
